/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks;

import com.tiviacz.pizzacraft.blockentity.MortarAndPestleBlockEntity;
import com.tiviacz.pizzacraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MortarAndPestleBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty PESTLE = BlockStateProperties.f_61407_;
    private static final VoxelShape INSIDE = MortarAndPestleBlock.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)MortarAndPestleBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), (VoxelShape)INSIDE, (BooleanOp)BooleanOp.f_82685_);

    public MortarAndPestleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)PESTLE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level.m_7702_(pos) instanceof MortarAndPestleBlockEntity) {
            MortarAndPestleBlockEntity mortarTile = (MortarAndPestleBlockEntity)level.m_7702_(pos);
            ItemStack itemHeld = player.m_21120_(handIn);
            if (itemHeld.m_41619_()) {
                if (player.m_6047_()) {
                    this.movePestle(level, pos, state);
                    if (mortarTile.canMix(player)) {
                        mortarTile.mix(level, player);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!mortarTile.isEmpty(mortarTile.getInventory())) {
                    mortarTile.extractStack(Utils.getProperSlotForExtract(mortarTile.getInventory()), player);
                    return InteractionResult.SUCCESS;
                }
            } else if (mortarTile.getInventory().getStackInSlot(3).m_41619_()) {
                mortarTile.insertStack(Utils.getProperSlotForInsert(itemHeld, mortarTile.getInventory()), player, handIn);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void movePestle(Level level, BlockPos pos, BlockState state) {
        level.m_46597_(pos, (BlockState)state.m_61122_((Property)PESTLE));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            if (level.m_7702_(pos) instanceof MortarAndPestleBlockEntity) {
                IItemHandlerModifiable inventory = ((MortarAndPestleBlockEntity)level.m_7702_(pos)).getInventory();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)inventory.getStackInSlot(i));
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PESTLE});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MortarAndPestleBlockEntity(pos, state);
    }
}

